/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.dom.Application;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.PlotElement;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;

public class PlotElementControllerUtil {
    public static DatumRange getTimeRange(Application dom, PlotElement pe) {
        if (pe == null) {
            return null;
        }
        DataSourceFilter dsf = dom.getController().getDataSourceFilterFor(pe);
        if (dsf == null) {
            return null;
        }
        TimeSeriesBrowse tsb = dsf.getController().getTsb();
        if (tsb != null) {
            if (dsf.getController().getTimeSeriesBrowseController().isListeningToAxis()) {
                return dsf.getController().getTimeSeriesBrowseController().getPlot().getXaxis().getRange();
            }
            return tsb.getTimeRange();
        }
        DatumRange dr = null;
        if (pe.getPlotDefaults() != null && pe.getPlotDefaults().getXaxis() != null) {
            dr = pe.getPlotDefaults().getXaxis().getRange();
        }
        if (dr == null) {
            return null;
        }
        if (UnitsUtil.isTimeLocation((Units)dr.getUnits())) {
            return dr;
        }
        return null;
    }
}

